(********************************************************************
 * COPYRIGHT -- B&R China
 ********************************************************************
 * Program: HiperfaceOffset
 * File: HiperfaceOffset.st
 * Author: mus
 * Created: February 24, 2014
 ********************************************************************
 * Implementation of program HiperfaceOffset
 ********************************************************************)

PROGRAM _INIT
	Axis1Obj := ADR(gAxis01);
END_PROGRAM


PROGRAM _CYCLIC

	
	CASE gHiperfaceOffsetCtrl.Monitor.Step OF
		
		STEP_WAIT_CMD:
			
			IF gHiperfaceOffsetCtrl.Cmd.SetOffset = 1 THEN
				gHiperfaceOffsetCtrl.Cmd.SetOffset := 0;
				gHiperfaceOffsetCtrl.Monitor.Done  := 0;
				
				//ǷΪ0
				IF gHiperfaceOffsetCtrl.Monitor.PhaseAngle <> 0 AND gHiperfaceOffsetCtrl.Monitor.PolePairs <> 0 AND 
					gHiperfaceOffsetCtrl.Monitor.SinRev <>0 AND gHiperfaceOffsetCtrl.Monitor.Resolution <>0  AND gHiperfaceOffsetCtrl.Monitor.MultiTurns <>0 THEN 
					gHiperfaceOffsetCtrl.Monitor.Step := STEP_READ_ACT_POSITION;
				ELSE
					gHiperfaceOffsetCtrl.Monitor.Step := STEP_ERROR;
					gHiperfaceOffsetCtrl.Alarm.ErrorID := ERROR_HP_PARA;
					gHiperfaceOffsetCtrl.Alarm.ErrorStep := STEP_WAIT_CMD;
				END_IF
				// ȡλ
			ELSIF 	gHiperfaceOffsetCtrl.Cmd.ReadPos THEN
					gHiperfaceOffsetCtrl.Monitor.Step := STEP_READ_ACT_POSITION;
	
			END_IF
			
		
		STEP_READ_ACT_POSITION:
			memset(ADR(SendBuffer),0,SIZEOF(SendBuffer));
			SendBuffer[0] 	:= 16#40;			//default encoder address;
			SendBuffer[1] 	:= 16#42;			//command code of read position;
			SendLength		:= 2;
			
			gHiperfaceOffsetCtrl.Monitor.Step := STEP_WAIT_READ_ACT_END;
			TransferStart := 1;
			
		STEP_WAIT_READ_ACT_END:
			
			IF TransferOK = 1 THEN
				TransferOK := 0;
				gHiperfaceOffsetCtrl.Monitor.Step := STEP_CAL_NEW_POSITION;	
				
				memcpy(ADR(TempActPosition),ADR(ReadBuffer[2]),4);
				
				ActPosition := swapUDINT(TempActPosition);
				IF gHiperfaceOffsetCtrl.Cmd.ReadPos THEN
					gHiperfaceOffsetCtrl.Cmd.ReadPos := 0;
					gHiperfaceOffsetCtrl.Monitor.Step := STEP_WAIT_CMD;	
				END_IF
			ELSIF gHiperfaceOffsetCtrl.Alarm.ErrorID <> 0 THEN
				gHiperfaceOffsetCtrl.Monitor.Step := STEP_ERROR;
			END_IF
		
		STEP_CAL_NEW_POSITION:
			ModeValue := gHiperfaceOffsetCtrl.Monitor.SinRev*gHiperfaceOffsetCtrl.Monitor.Resolution*gHiperfaceOffsetCtrl.Monitor.MultiTurns;
			IF (gHiperfaceOffsetCtrl.Monitor.PhaseAngle > 0) THEN
				Offset := REAL_TO_UDINT(ABS(gHiperfaceOffsetCtrl.Monitor.PhaseAngle)*gHiperfaceOffsetCtrl.Monitor.SinRev*gHiperfaceOffsetCtrl.Monitor.Resolution/((2*PI)*gHiperfaceOffsetCtrl.Monitor.PolePairs));
			ELSE
				Offset := REAL_TO_UDINT(ABS(gHiperfaceOffsetCtrl.Monitor.PhaseAngle+2*PI)*gHiperfaceOffsetCtrl.Monitor.SinRev*gHiperfaceOffsetCtrl.Monitor.Resolution/((2*PI)*gHiperfaceOffsetCtrl.Monitor.PolePairs));
			
			END_IF
			NewPosition := ActPosition + Offset;
			IF NewPosition >= gHiperfaceOffsetCtrl.Monitor.SinRev*gHiperfaceOffsetCtrl.Monitor.Resolution*gHiperfaceOffsetCtrl.Monitor.MultiTurns THEN
				NewPosition := NewPosition - gHiperfaceOffsetCtrl.Monitor.SinRev*gHiperfaceOffsetCtrl.Monitor.Resolution*gHiperfaceOffsetCtrl.Monitor.MultiTurns;
			END_IF

			TempNewPosition := swapUDINT(NewPosition);			
			gHiperfaceOffsetCtrl.Monitor.Step := STEP_SET_POSITION;
			
		STEP_SET_POSITION:
			memset(ADR(SendBuffer),0,SIZEOF(SendBuffer));
			SendBuffer[0] 	:= 16#40;			//default encoder address;
			SendBuffer[1] 	:= 16#43;			//command code of write position;
			memcpy(ADR(SendBuffer[2]),ADR(TempNewPosition),4);
			SendBuffer[6]	:= 16#55;			//access code;
			SendLength		:= 7;
			
			gHiperfaceOffsetCtrl.Monitor.Step := STEP_WAIT_SET_POSITION;
			TransferStart := 1;
			
			
		STEP_WAIT_SET_POSITION:
			IF TransferOK = 1 THEN
				TransferOK := 0;
				gHiperfaceOffsetCtrl.Monitor.Step := STEP_WAIT_CMD;	
				gHiperfaceOffsetCtrl.Monitor.Done := 1;
				
			ELSIF gHiperfaceOffsetCtrl.Alarm.ErrorID <> 0 THEN
				gHiperfaceOffsetCtrl.Monitor.Step := STEP_ERROR;
				
			END_IF
	
		STEP_ERROR:
			IF gHiperfaceOffsetCtrl.Cmd.ErrorAck = 1 THEN
				gHiperfaceOffsetCtrl.Cmd.ErrorAck 			:= 0;
				gHiperfaceOffsetCtrl.Alarm.ErrorID 			:= 0;
				gHiperfaceOffsetCtrl.Alarm.ErrorStep 		:= 0;
				gHiperfaceOffsetCtrl.Alarm.ErrorTransferStep:= 0;
				gHiperfaceOffsetCtrl.Monitor.Step 			:= STEP_WAIT_CMD;
				EncoderStatus := 0;
				memset(ADR(SendBuffer),0,SIZEOF(SendBuffer));
				memset(ADR(ReadBuffer),0,SIZEOF(ReadBuffer));				
			END_IF
					
	END_CASE
	
	
	CASE TransferStep OF
		
		STEP_TRANSFER_WAIT:
			IF TransferStart = 1 THEN
				memset(ADR(ReadBuffer),0,SIZEOF(ReadBuffer));
				TransferStep := STEP_TRANSFER_SET_DATA_LEN;
				TransferStart := 0;
			END_IF
		
		STEP_TRANSFER_SET_DATA_LEN:
		
			SendDataByteAdr := ADR(SendBuffer);
			
			MC_BR_WriteParID_0.DataType 	:= ncPAR_TYP_VOID;
			MC_BR_WriteParID_0.DataAddress 	:= ADR(SendLength);
			MC_BR_WriteParID_0.ParID 		:= ACP10PAR_ENCOD_SERIAL_DATA;
			MC_BR_WriteParID_0.Execute 		:= TRUE;
			
			IF (MC_BR_WriteParID_0.Done) THEN
				MC_BR_WriteParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_WRITE_BLOCK_SEGM;
							
			ELSIF (MC_BR_WriteParID_0.ErrorID <> 0) THEN
				MC_BR_WriteParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_WAIT;
				gHiperfaceOffsetCtrl.Alarm.ErrorID := MC_BR_WriteParID_0.ErrorID;
				gHiperfaceOffsetCtrl.Alarm.ErrorTransferStep := STEP_TRANSFER_SET_DATA_LEN;
				
			END_IF
					
		STEP_TRANSFER_WRITE_BLOCK_SEGM:
			
			IF (SendLength > 6) THEN
				SegmParId := ACP10PAR_WR_BLOCK_SEGM;
			ELSE
				SegmParId := ACP10PAR_WR_BLOCK_LAST_SEGM;
			END_IF;
			
			
			MC_BR_WriteParID_0.DataType 	:= ncPAR_TYP_VOID;
			MC_BR_WriteParID_0.DataAddress 	:= SendDataByteAdr;
			MC_BR_WriteParID_0.ParID 		:= SegmParId;
			MC_BR_WriteParID_0.Execute 		:= TRUE;
			
			IF (MC_BR_WriteParID_0.Done) THEN
				MC_BR_WriteParID_0.Execute := FALSE;
				IF SendLength > 6 THEN
					SendLength 		:= SendLength - 6;
					SendDataByteAdr := SendDataByteAdr + 6;
				ELSE					
					TransferStep := STEP_TRANSFER_POLL_STATUS;
				END_IF
				
			ELSIF (MC_BR_WriteParID_0.ErrorID <> 0) THEN
				MC_BR_WriteParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_WAIT;
				gHiperfaceOffsetCtrl.Alarm.ErrorID := MC_BR_WriteParID_0.ErrorID;
				gHiperfaceOffsetCtrl.Alarm.ErrorTransferStep := STEP_TRANSFER_WRITE_BLOCK_SEGM;

			END_IF;
		
		
		STEP_TRANSFER_POLL_STATUS:
			MC_BR_ReadParID_0.DataType 		:= ncPAR_TYP_UINT;
			MC_BR_ReadParID_0.DataAddress 	:= ADR(EncoderStatus);
			MC_BR_ReadParID_0.ParID 		:= ACP10PAR_ENCOD_SERIAL_STATUS;
			MC_BR_ReadParID_0.Execute 		:= TRUE;	
			
			IF (MC_BR_ReadParID_0.Done) THEN
				MC_BR_ReadParID_0.Execute := FALSE;
				IF (EncoderStatus = 1) THEN
					TransferStep := STEP_TRANSFER_POLL_STATUS;
				ELSIF (EncoderStatus = 2) THEN
					TransferStep := STEP_TRANSFER_WAIT;
					gHiperfaceOffsetCtrl.Alarm.ErrorID := ERROR_TRANSFER_FAULTY;
					gHiperfaceOffsetCtrl.Alarm.ErrorTransferStep := STEP_TRANSFER_POLL_STATUS;

				ELSE 
					TransferStep := STEP_TRANSFER_READ_BLOCK_INIT;					
				END_IF;
			ELSIF (MC_BR_ReadParID_0.ErrorID <> 0) THEN
				MC_BR_ReadParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_WAIT;
				gHiperfaceOffsetCtrl.Alarm.ErrorID := MC_BR_ReadParID_0.ErrorID;
				gHiperfaceOffsetCtrl.Alarm.ErrorTransferStep := STEP_TRANSFER_POLL_STATUS;

			END_IF;				
		
		STEP_TRANSFER_READ_BLOCK_INIT:
			ReadDataStartAdr := ADR(ReadBuffer);
			ReadDataActAdr 	:= ReadDataStartAdr;
			TransferStep := STEP_TRANSFER_BLOCK_ABORT_READ;
	
		STEP_TRANSFER_BLOCK_ABORT_READ:
			TempVar := 0;
			MC_BR_WriteParID_0.DataType 	:= ncPAR_TYP_VOID;
			MC_BR_WriteParID_0.DataAddress 	:= ADR(TempVar);
			MC_BR_WriteParID_0.ParID 		:= ACP10PAR_CMD_RD_BLOCK_ABORT;
			MC_BR_WriteParID_0.Execute 		:= TRUE;
			
			IF (MC_BR_WriteParID_0.Done) THEN
				MC_BR_WriteParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_READ_DATA_LEN;
				
			ELSIF (MC_BR_WriteParID_0.ErrorID <> 0) THEN
				MC_BR_WriteParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_WAIT;
				gHiperfaceOffsetCtrl.Alarm.ErrorID := MC_BR_WriteParID_0.ErrorID;
				gHiperfaceOffsetCtrl.Alarm.ErrorTransferStep := STEP_TRANSFER_BLOCK_ABORT_READ;

			END_IF;
		
		STEP_TRANSFER_READ_DATA_LEN:
			MC_BR_ReadParID_0.DataType 		:= ncPAR_TYP_VOID;
			MC_BR_ReadParID_0.DataAddress 	:= ADR(ReadLength);
			MC_BR_ReadParID_0.ParID 		:= ACP10PAR_ENCOD_SERIAL_DATA;
			MC_BR_ReadParID_0.Execute 		:= TRUE;
			
			IF (MC_BR_ReadParID_0.Done) THEN
				MC_BR_ReadParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_READ_BLOCK_SEGM;
			ELSIF (MC_BR_ReadParID_0.ErrorID <> 0) THEN
				MC_BR_ReadParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_WAIT;
				gHiperfaceOffsetCtrl.Alarm.ErrorID := MC_BR_ReadParID_0.ErrorID;
				gHiperfaceOffsetCtrl.Alarm.ErrorTransferStep := STEP_TRANSFER_READ_DATA_LEN;

			END_IF;
			
		STEP_TRANSFER_READ_BLOCK_SEGM:
			IF (ReadLength > 6) THEN
				SegmParId := ACP10PAR_RD_BLOCK_SEGM;
			ELSE
				SegmParId := ACP10PAR_RD_BLOCK_LAST_SEGM;
			END_IF;
			
			MC_BR_ReadParID_0.DataType 		:= ncPAR_TYP_VOID;
			MC_BR_ReadParID_0.DataAddress 	:= ReadDataActAdr;
			MC_BR_ReadParID_0.ParID 		:= SegmParId;
			MC_BR_ReadParID_0.Execute 		:= TRUE;
			
			IF (MC_BR_ReadParID_0.Done) THEN
				MC_BR_ReadParID_0.Execute := FALSE;
				IF (ReadLength > 6) THEN
					ReadLength 		:= ReadLength-6;
					ReadDataActAdr 	:= ReadDataActAdr+6;
					TransferStep := STEP_TRANSFER_READ_BLOCK_SEGM;
				ELSE
					TransferStep := STEP_TRANSFER_WAIT;
					TransferOK := 1;
				END_IF
				
			ELSIF (MC_BR_ReadParID_0.ErrorID <> 0) THEN
				MC_BR_ReadParID_0.Execute := FALSE;
				TransferStep := STEP_TRANSFER_WAIT;
				gHiperfaceOffsetCtrl.Alarm.ErrorID := MC_BR_ReadParID_0.ErrorID;
				gHiperfaceOffsetCtrl.Alarm.ErrorTransferStep := STEP_TRANSFER_READ_BLOCK_SEGM;

			END_IF;	
			
	END_CASE
	
	
	MC_BR_ReadParID_0(Axis := Axis1Obj);
	MC_BR_WriteParID_0(Axis := Axis1Obj);		


END_PROGRAM
